/*:

@plugindesc
クリティカルヒットしたときに、SEを鳴らすことができます

@author
シトラス

@param criticalSeName
@type file
@dir audio/se/
@require 1
@desc
ここで記された名前のSEが敵にクリティカルヒットした時に
鳴ります
@default Thunder10

@param criticalSeVolume
@desc
敵にクリティカルヒットした時に鳴るSEの音量です
@default 100

@param criticalSePitch
@desc
敵にクリティカルヒットした時に鳴るSEのピッチです
@default 100

@param criticalSePan
@desc
敵にクリティカルヒットした時に鳴るSEのパンです
@default 0

@param fatalSeName
@type file
@dir audio/se/
@require 1
@desc
ここで記された名前のSEが味方にクリティカルヒットした時に
鳴ります
@default Earth5

@param fatalSeVolume
@desc
敵にクリティカルヒットした時に鳴るSEの音量です
@default 100

@param fatalSePitch
@desc
敵にクリティカルヒットした時に鳴るSEのピッチです
@default 100

@param fatalSePan
@desc
敵にクリティカルヒットした時に鳴るSEのパンです
@default 0

@help
このプラグインにプラグインコマンドはありません

*/
(function(){

//=============================================================================

var pluginName = "CustumCriticalSoundVer2";

var criticalSeName   = PluginManager.parameters(pluginName).criticalSeName;
var criticalSeVolume = Number(PluginManager.parameters(pluginName).criticalSeVolume);
var criticalSePitch  = Number(PluginManager.parameters(pluginName).criticalSePitch);
var criticalSePan    = Number(PluginManager.parameters(pluginName).criticalSePan);

var fatalSeName   = PluginManager.parameters(pluginName).fatalSeName;
var fatalSeVolume = Number(PluginManager.parameters(pluginName).fatalSeVolume);
var fatalSePitch  = Number(PluginManager.parameters(pluginName).fatalSePitch);
var fatalSePan    = Number(PluginManager.parameters(pluginName).fatalSePan);

//=============================================================================

SoundManager.playActorDamage = function() {
};

SoundManager.playEnemyDamage = function() {
};

SoundManager.playActorDamage_Sub = function() {
    this.playSystemSound(14);
};

SoundManager.playEnemyDamage_Sub = function() {
    this.playSystemSound(10);
};

//=============================================================================

var _BattleManager_initMembers = BattleManager.initMembers;
BattleManager.initMembers = function() {
    _BattleManager_initMembers.call(this);
    this._numSoundActorDamage = 0;
    this._cooldownSoundActorDamage = 0;
    this._numSoundEnemyDamage = 0;
    this._cooldownSoundEnemyDamage = 0;
};

BattleManager.stackSoundActorDamage = function() {
    this._numSoundActorDamage ++;
};
BattleManager.stackSoundEnemyDamage = function() {
    this._numSoundEnemyDamage ++;
};

BattleManager.updateSoundDamage = function() {
    if (this._cooldownSoundActorDamage > 0) {
        this._cooldownSoundActorDamage --;
    }
    if (this._cooldownSoundEnemyDamage > 0) {
        this._cooldownSoundEnemyDamage --;
    }
    if (this._numSoundActorDamage > 0 && this._cooldownSoundActorDamage <= 0) {
        this.performSoundActorDamage();
    }
    if (this._numSoundEnemyDamage > 0 && this._cooldownSoundEnemyDamage <= 0) {
        this.performSoundEnemyDamage();
    }
}

BattleManager.performSoundActorDamage = function() {
    this._numSoundActorDamage --;
    this._cooldownSoundActorDamage = 4;
    SoundManager.playActorDamage_Sub();
};
BattleManager.performSoundEnemyDamage = function() {
    this._numSoundEnemyDamage --;
    this._cooldownSoundEnemyDamage = 4;
    SoundManager.playEnemyDamage_Sub();
};

//=============================================================================

var _Scene_Battle_update = Scene_Battle.prototype.update;
Scene_Battle.prototype.update = function() {
    _Scene_Battle_update.call(this);
    BattleManager.updateSoundDamage();
};

//=============================================================================

var _Game_Actor_performDamage = Game_Actor.prototype.performDamage;
Game_Actor.prototype.performDamage = function() {
  _Game_Actor_performDamage.call(this);
  BattleManager.stackSoundActorDamage();
  if (this._result.critical === true) {
    AudioManager.playSe( {"name":fatalSeName,"volume":fatalSeVolume,"pitch":fatalSePitch,"pan":fatalSePan} );
    $gameScreen.startShake(4, 8, 10);
  }
};

var _Game_Enemy_performDamage = Game_Enemy.prototype.performDamage;
Game_Enemy.prototype.performDamage = function() {
  _Game_Enemy_performDamage.call(this);
  BattleManager.stackSoundEnemyDamage();
  if (this._result.critical === true) {
    AudioManager.playSe( {"name":criticalSeName,"volume":criticalSeVolume,"pitch":criticalSePitch,"pan":criticalSePan} );
    $gameScreen.startShake(4, 8, 10);
  }
};

//=============================================================================
  
})();